<?php 
/*
    QPanel, Hosting Panel

    Copyright (C) 2000-2009     Kloxo - LxLabs
    Copyright (C) 2009-2010     Kloxo - LxCenter
    Copyright (C) 2011          QPanel - Quijost

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

include_once 'htmllib/lib/include.php';

if(file_exists('../utils.php')) 
{
    require_once '../utils.php';
}
else 
{
    require_once 'lib/utils.php';
}

function install_general_mine($value)
{
    $value = implode(' ', $value);
    echo 'Installing ' . $value. ' ... ' . "\n";
    system('PATH=\$PATH:/usr/sbin:/usr/bin yum -y install ' .$value.' | tee -a status.log', $status);
    showStatus($status, strlen('Installing ' . $value. ' ... '));
}

function installcomp_mail()
{
    echo 'Installing PEAR channels and dependencies' . PHP_EOL;
    system('pear channel-update "pear.php.net" | tee -a status.log'); # to remove old channel warning
    system('pear upgrade --force pear | tee -a status.log'); # force is needed
    system('pear upgrade --force Archive_Tar | tee -a status.log'); # force is needed
    system('pear upgrade --force structures_graph | tee -a status.log'); # force is needed
    system('pear install log | tee -a status.log');
}

function checkIfYes($arg)
{
    return ($arg == 'y' || $arg == 'yes' || $arg == 'Y' || $arg == 'YES');
}

function getAcceptValue($soft)
{
    print("Do you want me to install $soft Components? (YES/no):");
    flush();
    $argq = fread(STDIN, 5);
    $arg = trim($argq);
    if (!$arg) $arg = 'yes';
    return $arg;
}

echo 'Installing PEAR mail component ...' . PHP_EOL;
installcomp_mail();
echo PHP_EOL;

echo 'Installing mail component ...' . PHP_EOL;
install_general_mine(array('vpopmail',
                            'courier-imap-toaster',
                            'courier-authlib-toaster',
                            'qmail',
                            'safecat',
                            'httpd',
                            'spamassassin',
                            'ezmlm-toaster',
                            'autorespond-toaster')); // mail
echo PHP_EOL;

echo 'Installing web component ...' . PHP_EOL;
install_general_mine(array('httpd',
                           'pure-ftpd')); // web
echo PHP_EOL;

echo 'Installing dns component ...' . PHP_EOL;
install_general_mine(array('bind',
                           'bind-chroot')); // dns
echo PHP_EOL;

echo 'Installing database component ...' . PHP_EOL;
install_general_mine(array('mysql')); // Database
echo PHP_EOL;