<?php
include_once('htmllib/lib/include.php');

$certificate_path = 'server.crt';
$key_path         = 'server.key';
$request_path     = 'a.csr';

$ltemp['countryName']            = 'IN';
$ltemp['stateOrProvinceName']    = 'Bn';
$ltemp['localityName']           = 'Bn';
$ltemp['organizationName']       = 'LxCenter';
$ltemp['organizationalUnitName'] = 'Kloxo';
$ltemp['commonName']             = 'Kloxo';
$ltemp['emailAddress']           = 'contact@lxcenter.org';

$private_key = openssl_pkey_new();
openssl_pkey_export_to_file($private_key, $key_path);

$csr = openssl_csr_new($ltemp, $private_key);
openssl_csr_export_to_file($csr, $request_path);

$ssl_certificate = openssl_csr_sign($csr, null, $private_key, 365);
openssl_x509_export_to_file($ssl_certificate, $certificate_path);

$src = getcwd();
$dest = '/usr/local/lxlabs/kloxo/ext/lxhttpd/conf';
root_execsys('lxfilesys_mkdir', $dest . '/ssl.crt/');
root_execsys('lxfilesys_mkdir', $dest . '/ssl.key/');
root_execsys('lxfilesys_mv',    $src . '/ ' . $certificate_path, $dest . '/ssl.crt/' . $certificate_path);
root_execsys('lxfilesys_mv',    $src . '/ ' . $key_path,         $dest . '/ssl.key/' . $certificate_path);
root_execsys('lxfilesys_mv',    $src . '/ ' . $request_path,     $dest . '/ ' . $request_path);