<?php
/*
    QPanel, Hosting Panel

    Copyright (C) 2000-2009     Kloxo - LxLabs
    Copyright (C) 2009-2010     Kloxo - LxCenter
    Copyright (C) 2011          QPanel - Quijost

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as
    published by the Free Software Foundation, either version 3 of the
    License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
error_reporting(E_ALL);
require_once '../utils.php';

$bugtracker_url = 'https://bugs.launchpad.net/qpanel'; #[FIXME] Move this to rigth place

$opt = parse_opt($argv);
$dir_name=dirname(__FILE__);

$unattended = isset($argv['2']) && $argv['2'] === 'unattended' ? TRUE: FALSE;

$install_type = $opt['install-type'];

if(empty($install_type) || ($install_type !== 'master' && $install_type !== 'slave' && $install_type !== 'supernode'))
{
    echo 'Error: install type empty or no recognized.' . PHP_EOL;
    exit();
}

$dbroot = isset($opt['db-rootuser']) ? $opt['db-rootuser']: 'root'; // @todo Undocumented parameter
$dbpass = isset($opt['db-rootpassword']) ? $opt['db-rootpassword']: NULL; // The initial mysql password for root is empty

$osversion = find_os_version();
$arch = `arch`;
$arch = trim($arch);

if(!char_search_beg($osversion, 'centos') && !char_search_beg($osversion, 'rhel'))
{
    echo getProductName(True) . ' is only supported on CentOS 5 and RHEL 5' . "\n";
    exit;
}

if(!$unattended)
{
    if(file_exists('/usr/local/lxlabs/kloxo'))
    {
        // Ask Reinstall
        if (get_yes_no(getProductName(True) . ' seems already installed do you wish to continue?') == 'n')
        {
            echo 'Installation Aborted.' . PHP_EOL;
            exit;
        }
    }
    else
    {
        // Ask License
        if (get_yes_no(getProductName(True) . ' is using AGPL-V3.0 License, do you agree with the terms?') == 'n')
        {
            echo 'You did not agree to the AGPL-V3.0 license terms.' . PHP_EOL .
                     'Installation aborted.' . PHP_EOL;
            exit;
        }
        else
        {
            echo 'Installing ' . getProductName(True) . ' = YES' . "\n\n";
        }
    }
}

if(!$unattended)
{
    $install_app = requestInstallApp();
}
else
{
    $install_app = FALSE; // No install by default
}

createUsersGroups();
installRepository($osversion);
uninstallPackages();
installPackages();

echo 'Prepare installation directory' . "\n";

system('mkdir -p /usr/local/'. getBrandName() . '/' . getProductName());

system('mkdir -p /usr/local/lxlabs/kloxo'); # [FIXME] Detect and ask to the user, save or delete or migrate
chdir('/usr/local/lxlabs/kloxo');

echo 'Making log directory' . PHP_EOL;
system('mkdir -p /usr/local/lxlabs/kloxo/log');
system('mkdir -p /usr/local/'. getBrandName() . '/'. getProductName() . '/log');

$download_needed = TRUE;

if(file_exists(getProductName() . '-current.zip'))
{
    if(!$unattended)
    {
        # Download again, only if the user choose remove the previous copy
        if(get_yes_no('There is a ' . getProductName() . '-current.zip downloaded on the current folder. Do you want remove and download again?') == 'y')
        {
            @unlink(getProductName() . '-current.zip');
            $download_needed = TRUE;
        }
        else 
        {
            $download_needed = FALSE;
        }
    }
    else
    {
        @unlink(getProductName() . '-current.zip'); 
        $download_needed = TRUE;
    }
}

if($download_needed)
{
    echo 'Downloading latest ' . getProductName(True) . ' release'. "\n";
    system('wget ' . $downloadserver . 'download/qpanel/production/' . getProductName() . '-current.zip');
}

echo PHP_EOL . 'Installing ' . getProductName(True) . '...' . PHP_EOL;

if(file_exists('qpanel-current.zip'))
{
    if(!$unattended)
    {
        if(get_yes_no('Do you want show the progress of unzipping files? (Recommended for little servers)') == 'n')
        {
            system("unzip -oq qpanel-current.zip", $return);
            # [FIXME] Save the status
        }
        else
        {
            system("unzip -o qpanel-current.zip", $return);
        }
    }
    else 
    {
        system("unzip -oq qpanel-current.zip", $return);
    }
}
else
{
    echo 'Could not find the qpanel-current package. Aborting' . PHP_EOL;
    exit;
}

if($return)
{
    die('Unzipping the core Failed. Most likely it is corrupted. Report it at '. $bugtracker_url . PHP_EOL);
}

if(!$unattended)
{
    if(get_yes_no('Do you want remove qpanel-current.zip file? (Recommended delete for save webspace)') == 'y')
    {
        unlink('qpanel-current.zip');
    }
}
else
{
    unlink('qpanel-current.zip');
}

system('chown -R ' . getBrandName() . ':' . getBrandName() . ' /usr/local/' . getBrandName() . '/');

system("chown -R lxlabs:lxlabs /usr/local/lxlabs/"); // @deprecate this

chdir('/usr/local/lxlabs/kloxo/httpdocs/');

if(file_exists('/etc/init.d/mysqld'))
{
    echo 'Stopping mysql (if previously active)' . PHP_EOL;
    system('service mysqld stop > error.log < /dev/null', $status);
    system('killall -9 mysqld > error.log < /dev/null', $status);
    
    echo 'Starting mysql' . PHP_EOL;
    system('service mysqld start > error.log < /dev/null', $status);
}
else
{
    echo 'ERROR: Could not find a mysqld service for start. Check if mysql is properly installed. Aborting.' . PHP_EOL;
    exit;
}

if($install_type !== 'slave')
{
    check_default_mysql($dbroot, $dbpass);
}

echo 'Prepare defaults and configurations...' . PHP_EOL;

system("/usr/local/lxlabs/ext/php/php $dir_name/installall.php");

echo 'Adding general httpd conf' . PHP_EOL;

$pattern = 'Include /etc/httpd/conf/kloxo/' . getProductName() . '.conf';
$file = '/etc/httpd/conf/httpd.conf';
$comment = "#" . getProductName(TRUE);
addLineIfNotExist($file, $pattern, $comment);

echo 'Creating brand folders on httpd' . PHP_EOL;
// @todo Deprecate this
if(!file_exists('/etc/httpd/conf/kloxo/'))
{
    mkdir('/etc/httpd/conf/kloxo/');
}

if(!file_exists('/etc/httpd/conf/' . getProductName() . '/'))
{
    mkdir('/etc/httpd/conf/' . getProductName() . '/');
}

$dir_path = dirname(__FILE__);

copy($dir_path . '/' . getProductName() . '.conf', '/etc/httpd/conf/kloxo/' . getProductName() . '.conf');

createNamedConf();

// @todo Deprecate this
touch('/etc/httpd/conf/kloxo/virtualhost.conf');
touch('/etc/httpd/conf/kloxo/webmail.conf');
touch('/etc/httpd/conf/kloxo/init.conf');
if(!file_exists('/etc/httpd/conf/kloxo/forward/'))
{
    mkdir('/etc/httpd/conf/kloxo/forward/');
}
touch('/etc/httpd/conf/kloxo/forward/forwardhost.conf');

// Create conf files for httpd
touch('/etc/httpd/conf/' . getProductName() . '/virtualhost.conf');
touch('/etc/httpd/conf/' . getProductName() . '/webmail.conf');
touch('/etc/httpd/conf/' . getProductName() . '/init.conf');
if(!file_exists('/etc/httpd/conf/' . getProductName() . '/forward/'))
{
    mkdir('/etc/httpd/conf/' . getProductName() . '/forward/');
}
touch('/etc/httpd/conf/' . getProductName() . '/forward/forwardhost.conf');

$options_file = '/var/named/chroot/etc/global.options.named.conf';

if (!file_exists($options_file))
{
    echo 'Creating ' . $options_file . ' file' . PHP_EOL;
    touch($options_file);
    chown($options_file, 'named');

    $cont = file_get_contents($options_file);

    if (!preg_match("+options+i", $cont))
    {
        $example_options  = "acl \"quijost\" {\n";
        $example_options .= "   localhost;\n";
        $example_options .= "};\n\n";
        $example_options .= "options {" . PHP_EOL;
        $example_options .= "    max-transfer-time-in 60;\n";
        $example_options .= "    transfer-format many-answers;\n";
        $example_options .= "    transfers-in 60;\n";
        $example_options .= "    auth-nxdomain yes;\n";
        $example_options .= "    allow-transfer { \"lxcenter\"; };\n";
        $example_options .= "    allow-recursion { \"lxcenter\"; };\n";
        $example_options .= "    recursion no;\n";
        $example_options .= "    version \"Quijost-1.0\";\n";
        $example_options .= "};\n\n";
        $example_options .= "# Remove # to see all DNS queries\n";
        $example_options .= "#logging {\n";
        $example_options .= "#    channel query_logging {\n";
        $example_options .= "#    file \"/var/log/named_query.log\";\n";
        $example_options .= "#    versions 3 size 100M;\n";
        $example_options .= "#    print-time yes;\n";
        $example_options .= "#};\n\n";
        $example_options .= "#    category queries {\n";
        $example_options .= "#    query_logging;\n";
        $example_options .= "#};" . PHP_EOL;
        $example_options .= "#};". PHP_EOL;

        file_put_contents($options_file, $example_options. PHP_EOL);
    }
}

our_file_put_contents("/etc/sysconfig/spamassassin", "SPAMDOPTIONS=\" -v -d -p 783 -u lxpopuser\"");

echo 'Creating Vpopmail database...' . PHP_EOL;
$mypass = password_gen();
system("sh $dir_name/vpop.sh $dbroot \"$dbpass\" lxpopuser $mypass");

echo 'Creating httpd logs' . PHP_EOL;
system('chmod -R 755 /var/log/httpd/');
system('chmod -R 755 /var/log/httpd/fpcgisock >/dev/null 2>&1');

echo 'Creating ' . getProductName(True) . ' logs' . PHP_EOL;
system('mkdir -p /var/log/kloxo/'); // @deprecate
system('mkdir -p /var/log/' . getProductName() . '/');

echo 'Creating news log' . PHP_EOL;
system("mkdir -p /var/log/news");

echo 'Creating sendmail symlinks' . PHP_EOL;
system('ln -sf /var/qmail/bin/sendmail /usr/sbin/sendmail');
system('ln -sf /var/qmail/bin/sendmail /usr/lib/sendmail');

echo 'Configuring email server' . PHP_EOL;
system("echo `hostname` > /var/qmail/control/me");
system('service qmail restart >/dev/null 2>&1 &');
system('service courier-imap restart >/dev/null 2>&1 &');

echo 'Creating databases' . PHP_EOL;

$dbfile='/home/kloxo/httpd/webmail/horde/scripts/sql/create.mysql.sql';
if(file_exists($dbfile))
{
    if($dbpass == "") 
    {
        system("mysql -u $dbroot  <$dbfile");
    }
    else 
    {
        system("mysql -u $dbroot -p$dbpass <$dbfile");
    }
}

echo 'Creating home httpd path' . PHP_EOL;
system('mkdir -p /home/kloxo/httpd');
system('mkdir -p /home/' . getProductName() . '/httpd');

echo 'Deleting skeleton-disable.zip' . PHP_EOL;
chdir("/home/kloxo/httpd");
@unlink("skeleton-disable.zip");

echo 'Changing permissions for home httpd path' . PHP_EOL;
system('chown -R lxlabs:lxlabs /home/kloxo/httpd');

echo 'Restarting ' . getProductName(True) . PHP_EOL;
system('/etc/init.d/kloxo restart >/dev/null 2>&1 &');
//system("/etc/init.d/qpanel restart >/dev/null 2>&1 &");

echo 'Executing create script' . PHP_EOL;
chdir('/usr/local/lxlabs/kloxo/httpdocs/');

switch($install_type)
{
    case 'master':
        $creation_script = '/usr/local/lxlabs/kloxo/httpdocs/htmllib/script/make-master';
    break;
    case 'slave':
        $creation_script = '/usr/local/lxlabs/kloxo/httpdocs/htmllib/script/make-slave';
    break;
    case 'supernode':
        $creation_script = '/usr/local/lxlabs/kloxo/httpdocs/htmllib/script/make-supernode';
    break;
}

system('/usr/local/lxlabs/ext/php/php ' . $creation_script . ' --db-rootuser ' . $dbroot . ' --password ' . $dbpass);

if($install_app)
{ // [FIXME] Unify in one call
    echo 'First run (gets installappdata)' . PHP_EOL;
    system('/script/installapp-update'); // First run (gets installappdata)

    echo 'Second run (gets applications)' . PHP_EOL;
    system('/script/installapp-update'); // Second run (gets applications)
}

echo PHP_EOL. 'Congratulations. ' . getProductName(True) . ' has been installed succesfully on your server as ' . $install_type . PHP_EOL . PHP_EOL;

if($install_type === 'master')
{
    echo 'You can connect to the server at https://<ip-address>:7777 or http://<ip-address>:7778' . PHP_EOL .
        'Please note that first is secure ssl connection, while the second is normal one.' . PHP_EOL . PHP_EOL . 
        'The login and password are \'admin\' \'admin\'. After Logging in, you will have to change your password to something more secure' .PHP_EOL . 
        'We hope you will find managing your hosting with ' . getProductName(True) . ' refreshingly pleasurable, and also we wish you all the ' .
        'success on your hosting venture' . PHP_EOL .
        'Thanks for choosing ' . getProductName(True) . ' to manage your hosting, and allowing us to be of service' . PHP_EOL;
}
else
{   # [FIXME] Check if the port 7779 is open with ping -n -c 1 -w 5
    echo 'You should open the port 7779 on this server, since this is used for the communication between master and slave' ."\n" .
        'To access this slave, to go admin->servers->add server, give the ip/machine name of this server. The password is \'admin\'. 
		 The slave will appear in the list of slaves, and you can access it just like you access localhost' . "\n\n";
}