<?php
/*
QPanel, Hosting Panel

Copyright (C) 2000-2009     Kloxo - LxLabs
Copyright (C) 2009-2010     Kloxo - LxCenter
Copyright (C) 2011          QPanel - Quijost

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

$downloadserver = 'http://download.' . getProductName() . '.' . getBrandName() . '.com/';
$ok_str = chr(27). "[1;32m [OK]" . chr(27) . "[0m";
$fail_str = chr(27). "[0;31m [FAIL]" . chr(27) . "[0m";

function showStatus($status, $chars)
{ # Print dotted lines and coloured state of a result given
    global $ok_str, $fail_str;
    
    echo ($status != 0) ?
        str_pad($fail_str, 90 - $chars, '.', STR_PAD_LEFT) . "\n" :
        str_pad($ok_str, 90 - $chars, '.', STR_PAD_LEFT) . "\n";
}

function getBrandName($uppercase = false)
{
    # Returns the name of the brand. The $uppercase params show the first letter uppercase if it is true
    return ($uppercase) ? 'Quijost': 'quijost';
}

function getProductName($uppercase = false)
{
    # Returns the name of the product. The $uppercase params show the first letter uppercase if it is true
    return ($uppercase) ? 'QPanel': 'qpanel';
}

function slave_get_db_pass()
{
    $file = "/usr/local/lxlabs/kloxo/etc/slavedb/dbadmin";
    if (!file_exists($file)) return null;
    $var = file_get_contents($file);
    $rmt = unserialize($var);
    return $rmt->data['mysql']['dbpassword'];
}

function addLineIfNotExistTemp($filename, $pattern, $comment)
{
    $cont = our_file_get_contents($filename);

    if (!preg_match("+$pattern+i", $cont))
    {
        our_file_put_contents($filename, "\n$comment \n\n", true);
        our_file_put_contents($filename, $pattern, true);
        our_file_put_contents($filename, "\n\n\n", true);
    }
    else
    {
        echo 'Pattern \'' . $pattern . '\' already present in ' . $filename . PHP_EOL;
    }
}

function check_default_mysql($dbroot, $dbpass)
{
    echo 'Restarting mysqld' . PHP_EOL;

    system('service mysqld restart');

    echo 'Checking access to mysql' . PHP_EOL;

    if ($dbpass)
    {
        exec("echo \"show tables\" | mysql -u $dbroot -p\"$dbpass\" mysql", $out, $return);
    }
    else
    {
        exec("echo \"show tables\" | mysql -u $dbroot mysql", $out, $return);
    }

    if ($return)
    {
        print("Fatal Error: Could not connect to Mysql Localhost using user $dbroot and password \"$dbpass\"\n");
        print("If this is a brand new install, you can completely remove mysql by running the commands below\n");
        print("            rm -rf /var/lib/mysql\n");
        print("            rpm -e mysql-server\n\n");
        print("And then run the installer again\n");
        exit;
    }
}

function parse_opt($argv)
{
    unset($argv[0]);
    if (!$argv) {
        return null;
    }
    foreach ($argv as $v) {
        if (strstr($v, "=") === false || strstr($v, "--") === false) {
            continue;
        }
        $opt = explode("=", $v);
        $opt[0] = substr($opt[0], 2);
        $ret[$opt[0]] = $opt[1];
    }
    return $ret;
}

function our_file_get_contents($file)
{
    $string = null;

    $fp = fopen($file, "r");

    if (!$fp) return null;

    while (!feof($fp)) {
        $string .= fread($fp, 8192);
    }
    fclose($fp);
    return $string;
}

function our_file_put_contents($file, $contents, $appendflag = false)
{
    $fp = fopen($file, ($appendflag) ? 'a' : 'w');
    if(!$fp) return NULL;
    fwrite($fp, $contents);
    fclose($fp);
}

function password_gen()
{
    $data = mt_rand(2, 30);
    $pass = "lx" . $data; // lx is a indentifier
    return $pass;
}

function strtil($string, $needle)
{
    return (strrpos($string, $needle)) ? substr($string, 0, strrpos($string, $needle)) : $string;
}

function strtilfirst($string, $needle)
{
    return (strpos($string, $needle)) ? substr($string, 0, strpos($string, $needle)) : $string;
}

function strfrom($string, $needle)
{
    return substr($string, strpos($string, $needle) + strlen($needle));
}

function char_search_beg($haystack, $needle)
{
    return strpos($haystack, $needle) === 0;
}

function install_rhn_sources($osversion)
{
    global $downloadserver;

    if(!file_exists("/etc/sysconfig/rhn/sources")) return;

    $data = our_file_get_contents("/etc/sysconfig/rhn/sources");
    if (!preg_match('/lxcenter/i', $data)) {
        $ndata = "yum lxcenter-updates " . $downloadserver . "download/update/$osversion/\$ARCH/\nyum
lxcenter-lxupdates " . $downloadserver . "download/update/lxgeneral";
        //append it to the file...
        our_file_put_contents("/etc/sysconfig/rhn/sources", "\n\n", true);
        our_file_put_contents("/etc/sysconfig/rhn/sources", $ndata, true);
        our_file_put_contents("/etc/sysconfig/rhn/sources", "\n\n", true);
    }
}

function install_yum_repo($osversion)
{
    if (!file_exists('/etc/yum.repos.d'))
    {
        echo 'Warning: No yum.repos.d dir detected!' . PHP_EOL;
        return;
    }

    if(file_exists('/etc/yum.repos.d/lxcenter.repo'))
    {
        if(get_yes_no('The LxCenter yum repository file is present. Do you want remove for avoid conflicts? (Recommended: yes)') == 'y')
        {
            @unlink('/etc/yum.repos.d/lxcenter.repo');
        }
    }

    if(file_exists('/etc/yum.repos.d/' . getBrandName() . '.repo'))
    {
        echo getProductName(True) . ' yum repository file already present.' . "\n";
    }
    else
    {
        # Get the .repo.template and replacce %distro% tag
        # [FIXME] This seems weird. Check if we can use file_get/put_contents instead
        $cont = our_file_get_contents('../' . getBrandName() . '.repo.template');
    $cont = str_replace('%distro%', $osversion, $cont);
    our_file_put_contents('/etc/yum.repos.d/' . getBrandName() . '.repo', $cont);

    echo 'Repository ' . getBrandName() . '.repo successfully installed' . PHP_EOL;
    }
}

function find_os_version()
{
    if (file_exists("/etc/fedora-release"))
    {
        $release = trim(file_get_contents("/etc/fedora-release"));
        $osv = explode(' ', $release);
        return 'fedora-' . $osv[(strtolower($osv[1]) === 'core') ? 3 : 2];
    }

    if (file_exists("/etc/redhat-release"))
    {
        $release = trim(file_get_contents("/etc/redhat-release"));
        $osv = explode(" ", $release);
        if (isset($osv[6])) $osversion = "rhel-" . $osv[6];
        else
        {
            $oss = explode(".", $osv[2]);
            $osversion = "centos-" . $oss[0];
        }
        return $osversion;
    }

    echo 'This Operating System is currently *NOT* supported.' . PHP_EOL;
    exit;
}

/**
 * Get Yes/No answer from stdin
 * @param string $question question text
 * @param char $default default answer (optional)
 * @return char 'y' for Yes or 'n' for No
 */
function get_yes_no($question, $default = 'n')
{
    if ($default != 'y')
    {
        $default = 'n';
        $question .= ' [y/N]: ';
    }
    else
    {
        $question .= ' [Y/n]: ';
    }

    for (;;)
    {
        print $question;
        flush();
        $input = fgets(STDIN, 255);
        $input = trim($input);
        $input = strtolower($input);

        if ($input == 'y' || $input == 'yes' || ($default == 'y' && $input == '' && empty($input)))
        {
            return 'y';
        }
        else if ($input == 'n' || $input == 'no' || ($default == 'n' && $input == '' && empty($input)))
        {
            return 'n';
        }
    }
}

function requestInstallApp()
{
    # Ask to the user if install InstallApp. Return true if the user choose yes, false if not.
    echo 'InstallApp: PHP Applications like PHPBB, WordPress, Joomla etc' . "\n" .
'When you choose Yes, be aware of downloading about 350Mb of data!' . "\n";

if(get_yes_no('Do you want to install the InstallAPP sotfware?') == 'n')
{
    echo 'Installing InstallApp = NO' . "\n" .
'You can install it later with /script/installapp-update' . "\n\n";
    return false;
}
else
{
    echo 'Installing InstallApp = YES' . "\n\n";
    return true;
}
}

function createUsersGroups()
{
    # Create the user and group for permissions on files
    echo 'Adding System users and groups (nouser, nogroup and lxlabs, lxlabs, ' . getBrandName() . ')' . PHP_EOL;

system('groupadd nogroup');
system('useradd nouser -g nogroup -s \'/sbin/nologin\'');

system('groupadd ' . getBrandName());
system('useradd ' . getBrandName() . ' -g ' . getBrandName() . ' -s \'/sbin/nologin\'');

# [FIXME] Remove when all it is done for Qpanel
system('groupadd lxlabs');
system('useradd lxlabs -g lxlabs -s \'/sbin/nologin\'');
}

function installRepository($osversion)
{
    # Install the main repository for updates and add disabled testing repo
    echo 'Installing '. getBrandName(true) . ' yum repository for updates' . "\n";
install_yum_repo($osversion);
}

function uninstallPackages()
{
    # Remove the main packages that can cause conflicts before to install
    $packages = array('sendmail',
'sendmail-cf',
'sendmail-doc',
'sendmail-devel',
'exim',
'vsftpd',
                  'postfix',
                  'vpopmail',
'qmail',
                  'lxphp',
'lxzend',
'pure-ftpd',
'imap');

$list = implode(' ', $packages);
echo 'Removing packages '.$list.' ...' . "\n";
foreach($packages as $package)
{
    exec('rpm -e --nodeps '.$package.' > /dev/null 2>&1'); #[FIXME] Use system command and get status
}
}

function installPackages()
{
    # Installs the packages need for the program from updade repository

    $packages = array('php53-mbstring',
'php53-mysql', // Redundant?
'which',
                      'gcc-c++',
'php53-imap',
'php-pear',
'php53-devel',
'lxlighttpd',
'httpd',
'mod_ssl',
'zip',
'unzip',
'lxphp',
    //'lxzend', not used?
'mysql',
'mysql-server',
    //'mysqlclient10', Deprecated?
'curl',
'autoconf',
'automake',
                      'libtool',
'bogofilter',
                      'gcc',
                      'cpp',
'openssl',
                      'pure-ftpd',
                      'yum-protectbase');

$list = implode(' ', $packages);
$attemps = 0;
$options = NULL;

while($attemps < 5)
{
    if($attemps == 1)
    {
        $options = ' --skip-broken ';
    }
    elseif($attemps == 2)
    {
        echo 'Trying to solve problems with package-cleanup' . "\n";
        system('package-cleanup --problems');
    }
    elseif($attemps == 3)
    {
        system('PATH=\$PATH:/usr/sbin:/usr/bin/ yum-complete-transaction');
    }

    echo 'Installing packages ' . $list . '...'. "\n";
    system('PATH=\$PATH:/usr/sbin:/usr/bin/ yum -y install ' . $options . $list, $return_value);

    # [FIXME] Check $return_value
    if(file_exists('/usr/local/lxlabs/ext/php/php')) // [FIXME] Weak check for install packages
    {
        break;
    }
    else
    {
        echo '[ERROR] Yum gave error ... Trying Again (attemp ' . $attemps . ')' . "\n";
    }

    $attemps++;
}
}

function addLineIfNotExist($filename, $pattern, $comment)
{
    $cont = file_get_contents($filename);

    if (!preg_match("+$pattern+i", $cont))
    {
        file_put_contents($filename, "\n$comment \n\n", FILE_APPEND);
        file_put_contents($filename, $pattern, FILE_APPEND);
        file_put_contents($filename, "\n\n\n", FILE_APPEND);
    }
    else
    {
        echo 'Pattern \'' . $pattern . '\' already present in ' . $filename . PHP_EOL;
    }
}

function createNamedConf()
{
    echo 'Creating named conf' . PHP_EOL;

    // @todo deprecate this
    $pattern = 'include "/etc/kloxo.named.conf";';
    $file = '/var/named/chroot/etc/named.conf';
    $comment = '//' . getProductName(TRUE) . '';
    addLineIfNotExist($file, $pattern, $comment);

    touch('/var/named/chroot/etc/kloxo.named.conf');
    chown('/var/named/chroot/etc/kloxo.named.conf', 'named');

    $pattern = 'include "/etc/' . getProductName() . '.named.conf";';
    $file = '/var/named/chroot/etc/named.conf';
    $comment = '//' . getProductName(TRUE) . '';
    addLineIfNotExist($file, $pattern, $comment);

    touch('/var/named/chroot/etc/' . getProductName() . '.named.conf');
    chown('/var/named/chroot/etc/' . getProductName() . '.named.conf', 'named');
}