/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import net.propero.rdp.RdesktopException;
import net.propero.rdp.RdpPacket_Localised;
import org.apache.log4j.Logger;

public abstract class RdpPacket {
    static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$RdpPacket == null ? (class$net$propero$rdp$RdpPacket = RdpPacket.class$("net.propero.rdp.RdpPacket")) : class$net$propero$rdp$RdpPacket));
    public static final int MCS_HEADER = 1;
    public static final int SECURE_HEADER = 2;
    public static final int RDP_HEADER = 3;
    public static final int CHANNEL_HEADER = 4;
    protected int mcs = -1;
    protected int secure = -1;
    protected int rdp = -1;
    protected int channel = -1;
    protected int start = -1;
    protected int end = -1;
    static /* synthetic */ Class class$net$propero$rdp$RdpPacket;

    public abstract int get8();

    public abstract int get8(int var1);

    public abstract void set8(int var1);

    public abstract void set8(int var1, int var2);

    public abstract int getLittleEndian16();

    public abstract int getLittleEndian16(int var1);

    public abstract void setLittleEndian16(int var1);

    public abstract void setLittleEndian16(int var1, int var2);

    public abstract int getBigEndian16();

    public abstract int getBigEndian16(int var1);

    public abstract void setBigEndian16(int var1);

    public abstract void setBigEndian16(int var1, int var2);

    public abstract int getLittleEndian32();

    public abstract int getLittleEndian32(int var1);

    public abstract void setLittleEndian32(int var1);

    public abstract void setLittleEndian32(int var1, int var2);

    public abstract int getBigEndian32();

    public abstract int getBigEndian32(int var1);

    public abstract void setBigEndian32(int var1);

    public abstract void setBigEndian32(int var1, int var2);

    public abstract void copyToByteArray(byte[] var1, int var2, int var3, int var4);

    public abstract void copyFromByteArray(byte[] var1, int var2, int var3, int var4);

    public abstract void copyToPacket(RdpPacket_Localised var1, int var2, int var3, int var4);

    public abstract void copyFromPacket(RdpPacket_Localised var1, int var2, int var3, int var4);

    public abstract int size();

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract void incrementPosition(int var1);

    public void markEnd() {
        this.end = this.getPosition();
    }

    public abstract int capacity();

    public void markEnd(int n) {
        if (n > this.capacity()) {
            throw new ArrayIndexOutOfBoundsException("Mark > size!");
        }
        this.end = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void pushLayer(int n, int n2) throws RdesktopException {
        this.setHeader(n);
        this.incrementPosition(n2);
    }

    public int getHeader(int n) throws RdesktopException {
        switch (n) {
            case 1: {
                return this.mcs;
            }
            case 2: {
                return this.secure;
            }
            case 3: {
                return this.rdp;
            }
            case 4: {
                return this.channel;
            }
        }
        throw new RdesktopException("Wrong Header!");
    }

    public void setHeader(int n) throws RdesktopException {
        switch (n) {
            case 1: {
                this.mcs = this.getPosition();
                break;
            }
            case 2: {
                this.secure = this.getPosition();
                break;
            }
            case 3: {
                this.rdp = this.getPosition();
                break;
            }
            case 4: {
                this.channel = this.getPosition();
                break;
            }
            default: {
                throw new RdesktopException("Wrong Header!");
            }
        }
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void outUnicodeString(String string, int n) {
        int n2 = 0;
        if (string.length() != 0) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < n; i += 2) {
                this.setLittleEndian16((short)cArray[n2++]);
            }
            this.setLittleEndian16(0);
        } else {
            this.setLittleEndian16(0);
        }
    }

    public void out_uint8p(String string, int n) {
        byte[] byArray = string.getBytes();
        this.copyFromByteArray(byArray, 0, this.getPosition(), byArray.length);
        this.incrementPosition(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

