/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.crypto;

import net.propero.rdp.crypto.BlockMessageDigest;

public final class MD5
extends BlockMessageDigest
implements Cloneable {
    private static final int HASH_LENGTH = 16;
    private static final int DATA_LENGTH = 64;
    private int[] data;
    private int[] digest;
    private byte[] tmp;

    protected int engineGetDigestLength() {
        return 16;
    }

    protected int engineGetDataLength() {
        return 64;
    }

    public MD5() {
        super("MD5");
        this.java_init();
        this.engineReset();
    }

    private void java_init() {
        this.digest = new int[4];
        this.data = new int[16];
        this.tmp = new byte[64];
    }

    private MD5(MD5 mD5) {
        this();
        this.data = (int[])mD5.data.clone();
        this.digest = (int[])mD5.digest.clone();
        this.tmp = (byte[])mD5.tmp.clone();
    }

    public Object clone() {
        return new MD5(this);
    }

    public void engineReset() {
        super.engineReset();
        this.java_reset();
    }

    private void java_reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
        this.digest[3] = 271733878;
    }

    protected void engineTransform(byte[] byArray) {
        this.java_transform(byArray);
    }

    private void java_transform(byte[] byArray) {
        MD5.byte2int(byArray, 0, this.data, 0, 16);
        this.transform(this.data);
    }

    public byte[] engineDigest(byte[] byArray, int n) {
        byte[] byArray2 = this.java_digest(byArray, n);
        this.engineReset();
        return byArray2;
    }

    private byte[] java_digest(byte[] byArray, int n) {
        int n2;
        if (n != 0) {
            System.arraycopy(byArray, 0, this.tmp, 0, n);
        }
        this.tmp[n++] = -128;
        if (n > 56) {
            while (n < 64) {
                this.tmp[n++] = 0;
            }
            MD5.byte2int(this.tmp, 0, this.data, 0, 16);
            this.transform(this.data);
            n = 0;
        }
        while (n < 56) {
            this.tmp[n++] = 0;
        }
        MD5.byte2int(this.tmp, 0, this.data, 0, 14);
        this.data[14] = n2 = this.bitcount();
        this.data[15] = 0;
        this.transform(this.data);
        byte[] byArray2 = new byte[16];
        int n3 = 0;
        for (int i = 0; i < 4; ++i) {
            int n4 = this.digest[i];
            byArray2[n3++] = (byte)n4;
            byArray2[n3++] = (byte)(n4 >>> 8);
            byArray2[n3++] = (byte)(n4 >>> 16);
            byArray2[n3++] = (byte)(n4 >>> 24);
        }
        return byArray2;
    }

    protected static int F(int n, int n2, int n3) {
        return n3 ^ n & (n2 ^ n3);
    }

    protected static int G(int n, int n2, int n3) {
        return n2 ^ n3 & (n ^ n2);
    }

    protected static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    protected static int I(int n, int n2, int n3) {
        return n2 ^ (n | ~n3);
    }

    protected static int FF(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.F(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    protected static int GG(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.G(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    protected static int HH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.H(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    protected static int II(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        n += n5 + n7 + MD5.I(n2, n3, n4);
        n = n << n6 | n >>> -n6;
        return n + n2;
    }

    protected void transform(int[] nArray) {
        int n = this.digest[0];
        int n2 = this.digest[1];
        int n3 = this.digest[2];
        int n4 = this.digest[3];
        n = MD5.FF(n, n2, n3, n4, nArray[0], 7, -680876936);
        n4 = MD5.FF(n4, n, n2, n3, nArray[1], 12, -389564586);
        n3 = MD5.FF(n3, n4, n, n2, nArray[2], 17, 606105819);
        n2 = MD5.FF(n2, n3, n4, n, nArray[3], 22, -1044525330);
        n = MD5.FF(n, n2, n3, n4, nArray[4], 7, -176418897);
        n4 = MD5.FF(n4, n, n2, n3, nArray[5], 12, 1200080426);
        n3 = MD5.FF(n3, n4, n, n2, nArray[6], 17, -1473231341);
        n2 = MD5.FF(n2, n3, n4, n, nArray[7], 22, -45705983);
        n = MD5.FF(n, n2, n3, n4, nArray[8], 7, 1770035416);
        n4 = MD5.FF(n4, n, n2, n3, nArray[9], 12, -1958414417);
        n3 = MD5.FF(n3, n4, n, n2, nArray[10], 17, -42063);
        n2 = MD5.FF(n2, n3, n4, n, nArray[11], 22, -1990404162);
        n = MD5.FF(n, n2, n3, n4, nArray[12], 7, 1804603682);
        n4 = MD5.FF(n4, n, n2, n3, nArray[13], 12, -40341101);
        n3 = MD5.FF(n3, n4, n, n2, nArray[14], 17, -1502002290);
        n2 = MD5.FF(n2, n3, n4, n, nArray[15], 22, 1236535329);
        n = MD5.GG(n, n2, n3, n4, nArray[1], 5, -165796510);
        n4 = MD5.GG(n4, n, n2, n3, nArray[6], 9, -1069501632);
        n3 = MD5.GG(n3, n4, n, n2, nArray[11], 14, 643717713);
        n2 = MD5.GG(n2, n3, n4, n, nArray[0], 20, -373897302);
        n = MD5.GG(n, n2, n3, n4, nArray[5], 5, -701558691);
        n4 = MD5.GG(n4, n, n2, n3, nArray[10], 9, 38016083);
        n3 = MD5.GG(n3, n4, n, n2, nArray[15], 14, -660478335);
        n2 = MD5.GG(n2, n3, n4, n, nArray[4], 20, -405537848);
        n = MD5.GG(n, n2, n3, n4, nArray[9], 5, 568446438);
        n4 = MD5.GG(n4, n, n2, n3, nArray[14], 9, -1019803690);
        n3 = MD5.GG(n3, n4, n, n2, nArray[3], 14, -187363961);
        n2 = MD5.GG(n2, n3, n4, n, nArray[8], 20, 1163531501);
        n = MD5.GG(n, n2, n3, n4, nArray[13], 5, -1444681467);
        n4 = MD5.GG(n4, n, n2, n3, nArray[2], 9, -51403784);
        n3 = MD5.GG(n3, n4, n, n2, nArray[7], 14, 1735328473);
        n2 = MD5.GG(n2, n3, n4, n, nArray[12], 20, -1926607734);
        n = MD5.HH(n, n2, n3, n4, nArray[5], 4, -378558);
        n4 = MD5.HH(n4, n, n2, n3, nArray[8], 11, -2022574463);
        n3 = MD5.HH(n3, n4, n, n2, nArray[11], 16, 1839030562);
        n2 = MD5.HH(n2, n3, n4, n, nArray[14], 23, -35309556);
        n = MD5.HH(n, n2, n3, n4, nArray[1], 4, -1530992060);
        n4 = MD5.HH(n4, n, n2, n3, nArray[4], 11, 1272893353);
        n3 = MD5.HH(n3, n4, n, n2, nArray[7], 16, -155497632);
        n2 = MD5.HH(n2, n3, n4, n, nArray[10], 23, -1094730640);
        n = MD5.HH(n, n2, n3, n4, nArray[13], 4, 681279174);
        n4 = MD5.HH(n4, n, n2, n3, nArray[0], 11, -358537222);
        n3 = MD5.HH(n3, n4, n, n2, nArray[3], 16, -722521979);
        n2 = MD5.HH(n2, n3, n4, n, nArray[6], 23, 76029189);
        n = MD5.HH(n, n2, n3, n4, nArray[9], 4, -640364487);
        n4 = MD5.HH(n4, n, n2, n3, nArray[12], 11, -421815835);
        n3 = MD5.HH(n3, n4, n, n2, nArray[15], 16, 530742520);
        n2 = MD5.HH(n2, n3, n4, n, nArray[2], 23, -995338651);
        n = MD5.II(n, n2, n3, n4, nArray[0], 6, -198630844);
        n4 = MD5.II(n4, n, n2, n3, nArray[7], 10, 1126891415);
        n3 = MD5.II(n3, n4, n, n2, nArray[14], 15, -1416354905);
        n2 = MD5.II(n2, n3, n4, n, nArray[5], 21, -57434055);
        n = MD5.II(n, n2, n3, n4, nArray[12], 6, 1700485571);
        n4 = MD5.II(n4, n, n2, n3, nArray[3], 10, -1894986606);
        n3 = MD5.II(n3, n4, n, n2, nArray[10], 15, -1051523);
        n2 = MD5.II(n2, n3, n4, n, nArray[1], 21, -2054922799);
        n = MD5.II(n, n2, n3, n4, nArray[8], 6, 1873313359);
        n4 = MD5.II(n4, n, n2, n3, nArray[15], 10, -30611744);
        n3 = MD5.II(n3, n4, n, n2, nArray[6], 15, -1560198380);
        n2 = MD5.II(n2, n3, n4, n, nArray[13], 21, 1309151649);
        n = MD5.II(n, n2, n3, n4, nArray[4], 6, -145523070);
        n4 = MD5.II(n4, n, n2, n3, nArray[11], 10, -1120210379);
        n3 = MD5.II(n3, n4, n, n2, nArray[2], 15, 718787259);
        n2 = MD5.II(n2, n3, n4, n, nArray[9], 21, -343485551);
        this.digest[0] = this.digest[0] + n;
        this.digest[1] = this.digest[1] + n2;
        this.digest[2] = this.digest[2] + n3;
        this.digest[3] = this.digest[3] + n4;
    }

    private static void byte2int(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        while (n3-- > 0) {
            nArray[n2++] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        }
    }
}

