/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp.rdp5.cliprdr;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.util.Iterator;
import net.propero.rdp.Common;
import net.propero.rdp.CommunicationMonitor;
import net.propero.rdp.Constants;
import net.propero.rdp.Options;
import net.propero.rdp.RdesktopException;
import net.propero.rdp.RdpPacket;
import net.propero.rdp.RdpPacket_Localised;
import net.propero.rdp.crypto.CryptoException;
import net.propero.rdp.rdp5.VChannel;
import net.propero.rdp.rdp5.cliprdr.ClipInterface;
import net.propero.rdp.rdp5.cliprdr.DIBHandler;
import net.propero.rdp.rdp5.cliprdr.TextHandler;
import net.propero.rdp.rdp5.cliprdr.TypeHandler;
import net.propero.rdp.rdp5.cliprdr.TypeHandlerList;
import net.propero.rdp.rdp5.cliprdr.UnicodeHandler;
import org.apache.log4j.Logger;

public class ClipChannel
extends VChannel
implements ClipInterface,
ClipboardOwner,
FocusListener {
    String[] types = new String[]{"unused", "CF_TEXT", "CF_BITMAP", "CF_METAFILEPICT", "CF_SYLK", "CF_DIF", "CF_TIFF", "CF_OEMTEXT", "CF_DIB", "CF_PALETTE", "CF_PENDATA", "CF_RIFF", "CF_WAVE", "CF_UNICODETEXT", "CF_ENHMETAFILE", "CF_HDROP", "CF_LOCALE", "CF_MAX"};
    protected static Logger logger = Logger.getLogger((Class)(class$net$propero$rdp$Input == null ? (class$net$propero$rdp$Input = ClipChannel.class$("net.propero.rdp.Input")) : class$net$propero$rdp$Input));
    public static final int CLIPRDR_CONNECT = 1;
    public static final int CLIPRDR_FORMAT_ANNOUNCE = 2;
    public static final int CLIPRDR_FORMAT_ACK = 3;
    public static final int CLIPRDR_DATA_REQUEST = 4;
    public static final int CLIPRDR_DATA_RESPONSE = 5;
    public static final int CLIPRDR_REQUEST = 0;
    public static final int CLIPRDR_RESPONSE = 1;
    public static final int CLIPRDR_ERROR = 2;
    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    TypeHandler currentHandler = null;
    TypeHandlerList allHandlers = new TypeHandlerList();
    byte[] localClipData = null;
    static /* synthetic */ Class class$net$propero$rdp$Input;

    public ClipChannel() {
        this.allHandlers.add(new UnicodeHandler());
        this.allHandlers.add(new TextHandler());
        this.allHandlers.add(new DIBHandler());
    }

    public String name() {
        return "cliprdr";
    }

    public int flags() {
        return -1063256064;
    }

    public void process(RdpPacket rdpPacket) throws RdesktopException, IOException, CryptoException {
        int n = rdpPacket.getLittleEndian16();
        int n2 = rdpPacket.getLittleEndian16();
        int n3 = rdpPacket.getLittleEndian32();
        if (n2 == 2) {
            if (n == 3) {
                this.send_format_announce();
                return;
            }
            return;
        }
        switch (n) {
            case 1: {
                this.send_format_announce();
                break;
            }
            case 2: {
                this.handle_clip_format_announce(rdpPacket, n3);
                return;
            }
            case 3: {
                break;
            }
            case 4: {
                this.handle_data_request(rdpPacket);
                break;
            }
            case 5: {
                this.handle_data_response(rdpPacket, n3);
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public void send_null(int n, int n2) {
        RdpPacket_Localised rdpPacket_Localised = new RdpPacket_Localised(12);
        rdpPacket_Localised.setLittleEndian16(n);
        rdpPacket_Localised.setLittleEndian16(n2);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.markEnd();
        try {
            this.send_packet(rdpPacket_Localised);
        }
        catch (RdesktopException rdesktopException) {
            System.err.println(rdesktopException.getMessage());
            rdesktopException.printStackTrace();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            iOException.printStackTrace();
        }
        catch (CryptoException cryptoException) {
            System.err.println(cryptoException.getMessage());
            cryptoException.printStackTrace();
        }
    }

    void send_format_announce() throws RdesktopException, IOException, CryptoException {
        Transferable transferable = this.clipboard.getContents(this.clipboard);
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        TypeHandlerList typeHandlerList = this.allHandlers.getHandlersForClipboard(dataFlavorArray);
        int n = typeHandlerList.count();
        RdpPacket_Localised rdpPacket_Localised = new RdpPacket_Localised(n * 36 + 12);
        rdpPacket_Localised.setLittleEndian16(2);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian32(n * 36);
        TypeHandler typeHandler = null;
        Iterator iterator = typeHandlerList.iterator();
        while (iterator.hasNext()) {
            typeHandler = (TypeHandler)iterator.next();
            rdpPacket_Localised.setLittleEndian32(typeHandler.preferredFormat());
            rdpPacket_Localised.incrementPosition(32);
        }
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.markEnd();
        this.send_packet(rdpPacket_Localised);
    }

    private void handle_clip_format_announce(RdpPacket rdpPacket, int n) throws RdesktopException, IOException, CryptoException {
        TypeHandlerList typeHandlerList = new TypeHandlerList();
        for (int i = n; i >= 36; i -= 36) {
            int n2 = rdpPacket.getLittleEndian32();
            rdpPacket.incrementPosition(32);
            typeHandlerList.add(this.allHandlers.getHandlerForFormat(n2));
        }
        this.send_null(3, 1);
        this.currentHandler = typeHandlerList.getFirst();
        if (this.currentHandler != null) {
            this.request_clipboard_data(this.currentHandler.preferredFormat());
        }
    }

    void handle_data_request(RdpPacket rdpPacket) throws RdesktopException, IOException, CryptoException {
        int n = rdpPacket.getLittleEndian32();
        Transferable transferable = this.clipboard.getContents(this);
        Object var4_4 = null;
        TypeHandler typeHandler = this.allHandlers.getHandlerForFormat(n);
        if (typeHandler != null) {
            typeHandler.send_data(transferable, this);
        }
    }

    void handle_data_response(RdpPacket rdpPacket, int n) {
        if (this.currentHandler != null) {
            this.currentHandler.handleData(rdpPacket, n, this);
        }
        this.currentHandler = null;
    }

    void request_clipboard_data(int n) throws RdesktopException, IOException, CryptoException {
        RdpPacket_Localised rdpPacket_Localised = Common.secure.init(Constants.encryption ? 8 : 0, 24);
        rdpPacket_Localised.setLittleEndian32(16);
        int n2 = 3;
        if ((this.flags() & 0x200000) != 0) {
            n2 |= 0x10;
        }
        rdpPacket_Localised.setLittleEndian32(n2);
        rdpPacket_Localised.setLittleEndian16(4);
        rdpPacket_Localised.setLittleEndian16(0);
        rdpPacket_Localised.setLittleEndian32(4);
        rdpPacket_Localised.setLittleEndian32(n);
        rdpPacket_Localised.setLittleEndian32(0);
        rdpPacket_Localised.markEnd();
        Common.secure.send_to_channel(rdpPacket_Localised, Constants.encryption ? 8 : 0, this.mcs_id());
    }

    public void send_data(byte[] byArray, int n) {
        block6: {
            CommunicationMonitor.lock(this);
            RdpPacket_Localised rdpPacket_Localised = new RdpPacket_Localised(12 + n);
            rdpPacket_Localised.setLittleEndian16(5);
            rdpPacket_Localised.setLittleEndian16(1);
            rdpPacket_Localised.setLittleEndian32(n + 4);
            rdpPacket_Localised.copyFromByteArray(byArray, 0, rdpPacket_Localised.getPosition(), n);
            rdpPacket_Localised.incrementPosition(n);
            rdpPacket_Localised.setLittleEndian32(0);
            try {
                this.send_packet(rdpPacket_Localised);
            }
            catch (RdesktopException rdesktopException) {
                System.err.println(rdesktopException.getMessage());
                rdesktopException.printStackTrace();
                if (!Common.underApplet) {
                    System.exit(-1);
                }
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                iOException.printStackTrace();
                if (!Common.underApplet) {
                    System.exit(-1);
                }
            }
            catch (CryptoException cryptoException) {
                System.err.println(cryptoException.getMessage());
                cryptoException.printStackTrace();
                if (Common.underApplet) break block6;
                System.exit(-1);
            }
        }
        CommunicationMonitor.unlock(this);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (Options.use_rdp5) {
            try {
                this.send_format_announce();
            }
            catch (RdesktopException rdesktopException) {
            }
            catch (IOException iOException) {
            }
            catch (CryptoException cryptoException) {
                // empty catch block
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void reset_bool(boolean[] blArray) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = false;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        logger.debug((Object)"Lost clipboard ownership");
    }

    public void copyToClipboard(Transferable transferable) {
        this.clipboard.setContents(transferable, this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

