/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.KeyStoreListener;
import com.sshtools.j2ssh.agent.KeyTimeoutException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStore {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$agent$KeyStore == null ? (class$com$sshtools$j2ssh$agent$KeyStore = KeyStore.class$("com.sshtools.j2ssh.agent.KeyStore")) : class$com$sshtools$j2ssh$agent$KeyStore);
    HashMap publickeys = new HashMap();
    HashMap privatekeys = new HashMap();
    HashMap constraints = new HashMap();
    Vector index = new Vector();
    Vector listeners = new Vector();
    String lockedPassword = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$KeyStore;

    public Map getPublicKeys() {
        return (Map)this.publickeys.clone();
    }

    public int indexOf(SshPublicKey sshPublicKey) {
        return this.index.indexOf(sshPublicKey);
    }

    public SshPublicKey elementAt(int n) {
        return (SshPublicKey)this.index.elementAt(n);
    }

    public String getDescription(SshPublicKey sshPublicKey) {
        return (String)this.publickeys.get(sshPublicKey);
    }

    public KeyConstraints getKeyConstraints(SshPublicKey sshPublicKey) {
        return (KeyConstraints)this.constraints.get(sshPublicKey);
    }

    public int size() {
        return this.index.size();
    }

    public void addKeyStoreListener(KeyStoreListener keyStoreListener) {
        this.listeners.add(keyStoreListener);
    }

    public void removeKeyStoreListener(KeyStoreListener keyStoreListener) {
        this.listeners.remove(keyStoreListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addKey(SshPrivateKey sshPrivateKey, SshPublicKey sshPublicKey, String string, KeyConstraints keyConstraints) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            block5: {
                if (this.publickeys.containsKey(sshPublicKey)) break block5;
                this.publickeys.put(sshPublicKey, string);
                this.privatekeys.put(sshPublicKey, sshPrivateKey);
                this.constraints.put(sshPublicKey, keyConstraints);
                this.index.add(sshPublicKey);
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onAddKey(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllKeys() {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            this.publickeys.clear();
            this.privatekeys.clear();
            this.constraints.clear();
            this.index.clear();
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                keyStoreListener.onDeleteAllKeys(this);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] performHashAndSign(SshPublicKey sshPublicKey, List list, byte[] byArray) throws KeyTimeoutException, InvalidSshKeyException, InvalidSshKeySignatureException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            block5: {
                if (!this.privatekeys.containsKey(sshPublicKey)) throw new InvalidSshKeyException("The key does not exist");
                SshPrivateKey sshPrivateKey = (SshPrivateKey)this.privatekeys.get(sshPublicKey);
                KeyConstraints keyConstraints = (KeyConstraints)this.constraints.get(sshPublicKey);
                if (!keyConstraints.canUse()) throw new KeyTimeoutException();
                if (keyConstraints.hasTimedOut()) break block5;
                keyConstraints.use();
                byte[] byArray2 = sshPrivateKey.generateSignature(byArray);
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onKeyOperation(this, "hash-and-sign");
                }
                return byArray2;
            }
            throw new KeyTimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKey(SshPublicKey sshPublicKey, String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            block5: {
                String string2;
                if (!this.publickeys.containsKey(sshPublicKey) || !string.equals(string2 = (String)this.publickeys.get(sshPublicKey))) break block5;
                this.publickeys.remove(sshPublicKey);
                this.privatekeys.remove(sshPublicKey);
                this.constraints.remove(sshPublicKey);
                this.index.remove(sshPublicKey);
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onDeleteKey(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            block5: {
                if (this.lockedPassword != null) break block5;
                this.lockedPassword = string;
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onLock(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlock(String string) throws IOException {
        HashMap hashMap = this.publickeys;
        synchronized (hashMap) {
            block5: {
                if (this.lockedPassword == null || !string.equals(this.lockedPassword)) break block5;
                this.lockedPassword = null;
                Iterator iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    KeyStoreListener keyStoreListener = (KeyStoreListener)iterator.next();
                    keyStoreListener.onUnlock(this);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

