/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class SshAgentKeyList
extends SubsystemMessage {
    public static final int SSH_AGENT_KEY_LIST = 104;
    private Map keys;

    public SshAgentKeyList(Map map) {
        super(104);
        this.keys = map;
    }

    public SshAgentKeyList() {
        super(104);
        this.keys = new HashMap();
    }

    public Map getKeys() {
        return this.keys;
    }

    public String getMessageName() {
        return "SSH_AGENT_KEY_LIST";
    }

    public void constructByteArray(ByteArrayWriter byteArrayWriter) throws IOException, InvalidMessageException {
        try {
            byteArrayWriter.writeInt(this.keys.size());
            Iterator iterator = this.keys.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SshPublicKey sshPublicKey = (SshPublicKey)entry.getKey();
                String string = (String)entry.getValue();
                byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
                byteArrayWriter.writeString(string);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to write message data");
        }
    }

    public void constructMessage(ByteArrayReader byteArrayReader) throws IOException, InvalidMessageException {
        try {
            int n = (int)byteArrayReader.readInt();
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray = byteArrayReader.readBinaryString();
                SshPublicKey sshPublicKey = SshKeyPairFactory.decodePublicKey(byArray);
                String string = byteArrayReader.readString();
                this.keys.put(sshPublicKey, string);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Failed to read message data");
        }
    }
}

