/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SshMsgUserAuthFailure
extends SshMessage {
    protected static final int SSH_MSG_USERAUTH_FAILURE = 51;
    private List auths;
    private boolean partialSuccess;

    public SshMsgUserAuthFailure() {
        super(51);
    }

    public SshMsgUserAuthFailure(String string, boolean bl) throws InvalidMessageException {
        super(51);
        this.loadListFromDelimString(string);
        this.partialSuccess = bl;
    }

    public List getAvailableAuthentications() {
        return this.auths;
    }

    public String getMessageName() {
        return "SSH_MSG_USERAUTH_FAILURE";
    }

    public boolean getPartialSuccess() {
        return this.partialSuccess;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            String string = null;
            Iterator iterator = this.auths.iterator();
            while (iterator.hasNext()) {
                string = (string == null ? "" : string + ",") + (String)iterator.next();
            }
            byteArrayWriter.writeString(string);
            byteArrayWriter.write(this.partialSuccess ? 1 : 0);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            String string = byteArrayReader.readString();
            this.partialSuccess = byteArrayReader.read() != 0;
            this.loadListFromDelimString(string);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    private void loadListFromDelimString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.auths = new ArrayList();
        while (stringTokenizer.hasMoreElements()) {
            this.auths.add(stringTokenizer.nextElement());
        }
    }
}

