/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.shift;

import com.sshtools.shift.DirectoryListingTableModel;
import java.awt.Component;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class FileSizeTableCellRenderer
extends DefaultTableCellRenderer {
    private static final NumberFormat KB_FILE_SIZE_FORMAT = new DecimalFormat();
    private static final NumberFormat MB_FILE_SIZE_FORMAT = new DecimalFormat();

    public FileSizeTableCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        long l = ((DirectoryListingTableModel)jTable.getModel()).getFileSize(n);
        this.setText(FileSizeTableCellRenderer.formatFileSize(l));
        return this;
    }

    public static String formatFileSize(long l) {
        double d = l;
        if (d < 1024.0) {
            return String.valueOf((int)d) + " bytes";
        }
        if (d < 1048576.0) {
            return KB_FILE_SIZE_FORMAT.format(d / 1024.0) + " KB";
        }
        return MB_FILE_SIZE_FORMAT.format(d / 1024.0 / 1024.0) + " MB";
    }

    static {
        KB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        KB_FILE_SIZE_FORMAT.setMaximumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMinimumFractionDigits(0);
        MB_FILE_SIZE_FORMAT.setMaximumFractionDigits(2);
    }
}

