/*
 * Decompiled with CFR 0.152.
 */
package net.propero.rdp;

import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.propero.rdp.Options;
import net.propero.rdp.RdesktopCanvas;

public class RdesktopCanvas_Localised
extends RdesktopCanvas {
    private Robot robot = null;
    BufferedImage apex_backstore = null;

    public static void saveToFile(Image image) {
        if (Options.server_bpp == 8) {
            return;
        }
        BufferedImage bufferedImage = null;
        bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        try {
            File file = new File("./testimages/" + Options.imgCount + ".jpg");
            ++Options.imgCount;
            ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        graphics.dispose();
    }

    RdesktopCanvas_Localised(int n, int n2) {
        super(n, n2);
        this.apex_backstore = new BufferedImage(n, n2, 1);
    }

    public void movePointer(int n, int n2) {
        Point point = this.getLocationOnScreen();
        this.robot.mouseMove(n += point.x, n2 += point.y);
    }

    protected Cursor createCustomCursor(Image image, Point point, String string, int n) {
        return Toolkit.getDefaultToolkit().createCustomCursor(image, point, "");
    }

    public void addNotify() {
        super.addNotify();
        if (this.robot == null) {
            try {
                this.robot = new Robot();
            }
            catch (AWTException aWTException) {
                logger.warn((Object)"Pointer movement not allowed");
            }
        }
    }

    public void update(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.drawImage(this.backstore.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height), rectangle.x, rectangle.y, null);
        if (Options.save_graphics) {
            RdesktopCanvas_Localised.saveToFile(this.backstore.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        }
    }
}

